#!/bin/sh
##
##  slideshow -- Observe and Control Slideshow Applications
##  Copyright (c) 2014-2023 Dr. Ralf S. Engelschall <http://engelschall.com>
##
##  This Source Code Form is subject to the terms of the Mozilla Public
##  License (MPL), version 2.0. If a copy of the MPL was not distributed
##  with this file, You can obtain one at http://mozilla.org/MPL/2.0/.
##
##  File:     connector-osx-kn6.sh
##  Purpose:  connector wrapper for Apple Keynote 6 under Mac OS X
##  Language: Bourne-Shell
##

#   determine base directory
case "$0" in
    /*  ) basedir=`echo $0 | sed -e 's;/[^/][^/]*$;;'` ;;
    */* ) basedir="`pwd`/`echo $0 | sed -e 's;/[^/][^/]*$;;'`" ;;
    * )
        OIFS=$IFS; IFS=":"
        for dir in $PATH; do
            IFS=$OIFS
            if [ -x "$dir/$0" ]; then
                basedir=$dir
                break
            fi
        done
        IFS=$OIFS
        ;;
esac
basedir=`echo "$basedir" | sed -e 's;/\.$;;g'`
basedir=`echo "$basedir" | sed -e 's;/\./;/;g'`
basedir=`echo "$basedir" | sed -e 's;/[^/][^/]*/\.\./;/;g'`
basedir=`echo "$basedir" | sed -e 's;/[^/][^/]*/\.\.$;;g'`

#   provide the stdin loop
while true; do
    #   read request
    read request
    if [ ".$request" = . ]; then
        echo "[DEBUG] Empty request received, exiting loop" >&2
        break
    fi
    command=`echo "$request" | sed -e 's;^.*command": *"\([^"]*\)".*$;\1;'`
    arg=`echo "$command" | cut -d' ' -f2`
    command=`echo "$command" | cut -d' ' -f1`

    #   let AppleScript produce the response
    osascript "$basedir/connector-osx-kn6.scpt" "$command" "$arg" 2>&1 || echo "[ERROR] AppleScript execution failed" >&2
done

