--
--  slideshow -- Observe and Control Slideshow Applications
--  Copyright (c) 2014-2023 Dr. Ralf S. Engelschall <http://engelschall.com>
--
--  This Source Code Form is subject to the terms of the Mozilla Public
--  License (MPL), version 2.0. If a copy of the MPL was not distributed
--  with this file, You can obtain one at http://mozilla.org/MPL/2.0/.
--
--  File:     connector-osx-kn6.scpt
--  Purpose:  connector engine for Apple Keynote 6 under Mac OS X
--  Language: AppleScript
--

--  main procedure
on run argv
    set command to item 1 of argv
    
    try
        tell application "Keynote"
            if not running then
                log "ERROR: Keynote is not running"
                return "{\"result\": false, \"error\": \"Keynote is not running\"}"
            end if
            
            if (count of documents) is 0 then
                log "ERROR: No presentation is open"
                return "{\"result\": false, \"error\": \"No presentation is open\"}"
            end if
            
            -- Get the current document
            set currentDoc to front document
            
            if command is "STAT" then
                set docState to "stopped"
                set slideNumber to 0
                tell currentDoc
                    try
                        if exists (get current slide) then
                            set slideNumber to slide number of current slide
                            if slideNumber > 0 then
                                set docState to "running"
                            end if
                        end if
                    end try
                end tell
                return "{\"response\": {\"state\": \"" & docState & "\", \"current\": " & slideNumber & "}}"
                
            else if command is "GOTO" then
                if playing then
                    set slideNum to item 2 of argv as number
                    show slide slideNum of currentDoc
                    return "{\"response\": {\"result\": true}}"
                else
                    return "{\"response\": {\"error\": \"Presentation not playing\"}}"
                end if
                
            else if command is "NEXT" then
                if playing then
                    show next
                    return "{\"response\": {\"result\": true}}"
                else
                    return "{\"response\": {\"error\": \"Presentation not playing\"}}"
                end if
                
            else if command is "PREV" then
                if playing then
                    show previous
                    return "{\"response\": {\"result\": true}}"
                else
                    return "{\"response\": {\"error\": \"Presentation not playing\"}}"
                end if
                
            else
                return "{\"result\": false, \"error\": \"Unknown command\"}"
            end if
            
        end tell
    on error errMsg
        log "ERROR: " & errMsg
        return "{\"result\": false, \"error\": \"" & errMsg & "\"}"
    end try
end run

